#include <maps/wikimap/mapspro/services/tasks_social/src/assessment_sampler/lib/tracker.h>

#include <maps/libs/chrono/include/format.h>
#include <maps/libs/st/include/gateway.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/secrets.h>

#include <fmt/format.h>


namespace maps::wiki::assessment::sampler {

namespace {

using namespace fmt::literals;

const std::string TRACKER_URL = "https://st-api.yandex-team.ru";


st::Configuration
getTrackerConfig()
{
    using namespace std::chrono_literals;
    using namespace maps::wiki::common::secrets;

    static std::optional<st::Configuration> result;

    if (result) {
        return *result;
    }

    st::RetryPolicy retryPolicy;
    retryPolicy.setMaxRequestAttempts(3);
    retryPolicy.setRetryInitialTimeout(1s);
    retryPolicy.setRetryTimeoutBackoff(3);

    result = st::Configuration{TRACKER_URL, tokenByKey(Key::RobotWikimapStToken)};
    result->setRetryPolicy(retryPolicy);
    return *result;
}


std::string
datetimeInterval(
    chrono::TimePoint timepointMin,
    chrono::TimePoint timepointMax)
{
    static const std::string DATE_TIME_FORMAT = "%Y-%m-%d %H:%M:%S";

    return fmt::format(
        "\"{from}\"..\"{to}\"",
        "from"_a = chrono::formatIntegralDateTime(timepointMin, DATE_TIME_FORMAT),
        "to"_a   = chrono::formatIntegralDateTime(timepointMax, DATE_TIME_FORMAT)
    );
}


TrackerIssues
loadTickets(const std::string query)
{
    auto issues = st::Gateway{getTrackerConfig()}.loadIssues(query);
    return {issues.begin(), issues.end()};
}

} // namespace


TrackerIssues
loadClosedTickets(
    chrono::TimePoint timepointMin,
    chrono::TimePoint timepointMax)
{
    return loadTickets(
        fmt::format(
            "queue: GEOCONTENTFB AND status: closed AND resolution: fixed AND Resolved: {interval}",
            "interval"_a = datetimeInterval(timepointMin, timepointMax)
        )
    );
}


TrackerIssues
loadOnSupportSideTickets(
    chrono::TimePoint timepointMin,
    chrono::TimePoint timepointMax)
{
    return loadTickets(
        fmt::format(
            "queue: GEOCONTENTFB AND (status: changed(to: naStoroneSapporta date: {interval}))",
            "interval"_a = datetimeInterval(timepointMin, timepointMax)
        )
    );
}


} // maps::wiki::assessment::sampler
