#include <maps/wikimap/mapspro/services/tasks_social/src/assessment_sampler/lib/grouped_units.h>

#include "helpers.h"

#include <maps/libs/chrono/include/time_point.h>

#include <library/cpp/testing/unittest/registar.h>


namespace maps::wiki::assessment::sampler::tests {

const chrono::TimePoint NOW = std::chrono::system_clock::now();

Y_UNIT_TEST_SUITE(grouped_units_tests) {
    Y_UNIT_TEST(should_merge_groups_with_different_keys) {
        const UnitVec units = {
            {0, {"entity 0", Entity::Domain::Edits}, {"action 0", 1, NOW}},
            {1, {"entity 1", Entity::Domain::Edits}, {"action 1", 1, NOW}},
            {2, {"entity 2", Entity::Domain::Edits}, {"action 2", 1, NOW}},
        };

        GroupNameToUnits result;
        result  = GroupNameToUnits{{"odd",  {units[1]}}};
        result += GroupNameToUnits{{"even", {units[0], units[2]}}};
        UNIT_ASSERT_VALUES_EQUAL(result.size(), 2);

        UNIT_ASSERT_VALUES_EQUAL(result.at("odd").size(),  1);
        UNIT_ASSERT_VALUES_EQUAL(result.at("even").size(), 2);

        UNIT_ASSERT_EQUAL(result.at("odd")[0], units[1]);

        auto evenUnits = result.at("even");
        sortUnits(evenUnits);
        UNIT_ASSERT_EQUAL(evenUnits[0], units[0]);
        UNIT_ASSERT_EQUAL(evenUnits[1], units[2]);
    }

    Y_UNIT_TEST(should_merge_groups_with_same_key) {
        const UnitVec units = {
            {0, {"entity 0", Entity::Domain::Edits}, {"action 0", 1, NOW}},
            {1, {"entity 1", Entity::Domain::Edits}, {"action 1", 1, NOW}},
            {2, {"entity 2", Entity::Domain::Edits}, {"action 2", 1, NOW}},
            {3, {"entity 3", Entity::Domain::Edits}, {"action 3", 1, NOW}},
        };

        GroupNameToUnits result;
        result  = {{"group", {units[0], units[2]}}};
        result += {{"group", {units[1], units[3]}}};
        UNIT_ASSERT_VALUES_EQUAL(result.size(), 1);

        UNIT_ASSERT_VALUES_EQUAL(result.at("group").size(), 4);

        auto groupUnits = result.at("group");
        sortUnits(groupUnits);
        for (size_t unitIx = 0; unitIx < units.size(); ++unitIx) {
            UNIT_ASSERT_EQUAL(groupUnits[unitIx], units[unitIx]);
        }
    }
}

} // namespace maps::wiki::assessment::sampler::tests
