#pragma once

#include <maps/libs/chrono/include/days.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/libs/assessment/include/sample.h>
#include <maps/wikimap/mapspro/libs/configs_editor/include/yandex/maps/wiki/configs/editor/common.h>
#include <maps/wikimap/mapspro/libs/revision/include/yandex/maps/wiki/revision/common.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/gateway_rw.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/task.h>
#include <maps/wikimap/mapspro/libs/social/tests/helpers/fb_task_creator.h>
#include <maps/wikimap/mapspro/services/tasks_social/src/assessment_sampler/lib/sample.h>

namespace maps::wiki::assessment::sampler::tests {

const size_t SEED = static_cast<size_t>(std::time(nullptr));
const Entity::Domain GENERATED_ENTITY_DOMAIN = Entity::Domain::Feedback;

const TUid USER = social::feedback::tests::FbTaskCreator::DEFAULT_UID;
const TUid ANOTHER_USER = USER + 1;
const TUids BOTH_USERS { USER, ANOTHER_USER };

const std::string SOURCE_TASK = "source-task";

const std::string ACTION_ACCEPT = "accept";
const std::string ACTION_NEED_INFO = "need-info";
const std::string ACTION_OBJECT_DELETED = "object-deleted";
const std::string ACTION_OBJECT_MODIFIED = "object-modified";

const std::string RD_JC_CATEGORY = "rd_jc";
const std::string RD_EL_CATEGORY = "rd_el";

const std::string DATE_STR_PREV = "2020-09-30T12:00:00";
const std::string DATE_STR      = "2020-10-01T12:00:00";
const std::string DATE_STR_NEXT = "2020-10-02T12:00:00";
const auto DATE = chrono::parseIsoDateTime(DATE_STR);

std::pair<chrono::TimePoint, chrono::TimePoint> txnNowSpan(pqxx::transaction_base& txn);

UnitVec generateUnits(size_t size, TUid uid = USER);
void sortUnits(UnitVec& units);
UnitVec unitsSetDifference(const UnitVec& lhs, const UnitVec& rhs);

social::Task createNewTask(pqxx::transaction_base& txn);

social::Task createResolvedTask(
    pqxx::transaction_base& txn,
    TUid resolvedBy,
    chrono::TimePoint resolvedAt);

social::Task createClosedTask(
    pqxx::transaction_base& txn,
    TUid resolvedBy,
    chrono::TimePoint resolvedAt,
    TUid closedBy,
    chrono::TimePoint closedAt);

TId createEditCommitEvent(
    pqxx::transaction_base& txn,
    TUid createdBy,
    chrono::TimePoint createdAt,
    const std::string& action,
    const std::optional<std::string>& primaryObjectCategoryId = RD_JC_CATEGORY,
    maps::wiki::revision::DBID branchId = maps::wiki::revision::TRUNK_BRANCH_ID);

configs::editor::StringSet serviceGroupCategories();

} // maps::wiki::assessment::sampler::tests
