#include <maps/wikimap/mapspro/services/tasks_social/src/assessment_sampler/lib/sample.h>

#include <maps/wikimap/mapspro/libs/assessment/include/gateway.h>

#include <maps/wikimap/mapspro/services/tasks_social/src/assessment_sampler/tests/helpers.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/arcadia.h>

#include <library/cpp/testing/unittest/registar.h>


namespace maps::wiki::assessment::sampler::tests {

Y_UNIT_TEST_SUITE(units_sampling_tests) {
    Y_UNIT_TEST(should_generate_sample_name_for_domains) {
        for (const auto domain: enum_io::enumerateValues<Entity::Domain>()) {
            UNIT_ASSERT_EQUAL(
                sampleName(domain, Qualification::Basic, DATE, 1, StaffType::Staff, HypothesesMode::No),
                std::string(toString(domain)) + "-20201001"
            );
        }
    }

    Y_UNIT_TEST(should_generate_sample_name_for_experts) {
        UNIT_ASSERT_EQUAL(
            sampleName(Entity::Domain::Feedback, Qualification::Expert, DATE, 1, StaffType::Staff, HypothesesMode::No),
            "expert-feedback-20201001");
    }

    Y_UNIT_TEST(should_generate_sample_name_for_several_days) {
        UNIT_ASSERT_EQUAL(
            sampleName(Entity::Domain::Feedback, Qualification::Basic, DATE, 10, StaffType::Staff, HypothesesMode::No),
            "feedback-20200922-20201001");
    }

    Y_UNIT_TEST(should_generate_sample_name_for_pieceworkers) {
        UNIT_ASSERT_EQUAL(
            sampleName(Entity::Domain::Feedback, Qualification::Basic, DATE, 1, StaffType::Piecework, HypothesesMode::No),
            "piecework-feedback-20201001");
    }

    Y_UNIT_TEST(should_generate_sample_name_for_outsourcers) {
        UNIT_ASSERT_EQUAL(
            sampleName(Entity::Domain::Feedback, Qualification::Basic, DATE, 1, StaffType::Outsource, HypothesesMode::No),
            "outsource-feedback-20201001");
    }

    Y_UNIT_TEST(should_generate_sample_name_for_hypotheses) {
        UNIT_ASSERT_EQUAL(
            sampleName(Entity::Domain::Feedback, Qualification::Basic, DATE, 1, StaffType::Staff, HypothesesMode::Yes),
            "feedback-hypotheses-20201001");
    }

    Y_UNIT_TEST(should_generate_sample_name_with_several_modifiers) {
        UNIT_ASSERT_EQUAL(
            sampleName(Entity::Domain::Feedback, Qualification::Expert, DATE, 10, StaffType::Piecework, HypothesesMode::Yes),
            "piecework-expert-feedback-hypotheses-20200922-20201001");
    }
}

} // maps::wiki::assessment::sampler::tests
