#include <maps/wikimap/mapspro/services/tasks_social/src/auto_mailer/lib/addresses_email.h>
#include <maps/wikimap/mapspro/services/tasks_social/src/auto_mailer/lib/email_queue.h>

#include <yandex/maps/wiki/social/sent_notification_gateway.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/common/pg_advisory_lock_ids.h>
#include <yandex/maps/wiki/common/yt.h>

#include <maps/wikimap/mapspro/libs/sqs_client/include/aws_api.h>

#include <yandex/maps/pgpool3utils/pg_advisory_mutex.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/common/include/exception.h>

#include <mapreduce/yt/interface/client.h>

#include <string>

const std::string SQS_QUEUE_NAME = "notifications";

namespace auto_mailer = maps::wiki::auto_mailer;

int main(int argc, char** argv) try {
    maps::wiki::sqs::AwsAPI awsApi;

    NYT::Initialize(argc, argv);
    auto client = maps::wiki::common::yt::createYtClient("hahn");

    maps::cmdline::Parser parser;
    auto servicesConfigArg = parser.string("services-config")
        .help("path to services config");
    auto syslogTag = parser.string("syslog-tag")
        .help("Redirect log output to syslog with given tag");
    parser.parse(argc, argv);

    if (syslogTag.defined()) {
        maps::log8::setBackend(maps::log8::toSyslog(syslogTag));
    }

    std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> servicesConfig;
    if (servicesConfigArg.defined()) {
        servicesConfig = std::make_unique<maps::wiki::common::ExtendedXmlDoc>(servicesConfigArg);
    } else {
        servicesConfig = maps::wiki::common::loadDefaultConfig();
    }

    maps::wiki::common::PoolHolder socialDbPoolHolder{*servicesConfig, "social", "grinder"};

    maps::pgp3utils::PgAdvisoryXactMutex guard(
        socialDbPoolHolder.pool(),
        static_cast<int64_t>(maps::wiki::common::AdvisoryLockIds::AUTO_MAILER)
    );
    if (!guard.try_lock()) {
        INFO() << "Auto mailer is already running (DB is locked)";
        return EXIT_SUCCESS;
    }

    auto socialTxn = socialDbPoolHolder.pool().masterWriteableTransaction();
    maps::wiki::social::SentNotificationGateway notificationsGateway(*socialTxn);

    auto_mailer::EmailQueue emailQueue(*servicesConfig, SQS_QUEUE_NAME);

    auto_mailer::sendAddressesMessages(client, emailQueue, notificationsGateway);

    INFO() << "Auto mailer finished";
    return EXIT_SUCCESS;
} catch (const maps::Exception& ex) {
    FATAL() << "Auto mailer failed: " << ex;
    return EXIT_FAILURE;
} catch (const std::exception& ex) {
    FATAL() << "Auto mailer failed: " << ex.what();
    return EXIT_FAILURE;
}
