#include "email_queue.h"

namespace maps::wiki::auto_mailer {

bool EmailQueue::send(const MessageInfo& info) {
    json::Builder builder;
    builder << info;
    const std::string eventSerialized = builder.str();

    Aws::SQS::Model::SendMessageRequest sendRequest;
    sendRequest.SetQueueUrl(sqsConfig_.getQueueUrl(sqsQueueName_));
    sendRequest.SetMessageBody(eventSerialized);

    auto sendResult = sqsClient_.SendMessage(sendRequest);

    if (sendResult.IsSuccess()) {
        return true;
    }

    ERROR() << "Failed sending message " << eventSerialized
            << " to queue " << sqsQueueName_ << ". "
            << sendResult.GetError().GetMessage();
    return false;
}

}  // namespace maps::wiki::auto_mailer
