#pragma once

#include "message_info.h"

#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/client.h>

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <maps/libs/log8/include/log8.h>

#include <aws/sqs/model/SendMessageRequest.h>

#include <string>

namespace maps::wiki::auto_mailer {

class EmailQueue {
public:
    EmailQueue(const common::ExtendedXmlDoc& nmapsServicesConfig, std::string sqsQueueName)
        : sqsQueueName_(std::move(sqsQueueName))
        , sqsConfig_(nmapsServicesConfig)
        , sqsClient_(sqs::createSqsClient(sqsConfig_)) {}

    bool send(const MessageInfo& info);

private:
    std::string sqsQueueName_;
    sqs::Configuration sqsConfig_;
    Aws::SQS::SQSClient sqsClient_;
};

}  // namespace maps::wiki::auto_mailer
