#include "message_info.h"

namespace maps::wiki::auto_mailer {

AddressesMessageInfo::AddressesMessageInfo(const NYT::TNode& row) {
    puid_ = std::stoull(row["puid"].AsString());
    showsCount_ = row["shows_count"].AsInt64();
}

void AddressesMessageInfo::json(json::ObjectBuilder builder) const {
    builder["puid"] = puid_;
    builder["mail-type"] = ADDRESSES_MAIL_TYPE;
    builder["args"] << [this](json::ObjectBuilder builder) {
        builder["showsCount"] = showsCount_;
    };
}

}  // namespace maps::wiki::auto_mailer
