#pragma once

#include <string>

#include <maps/libs/json/include/builder.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::auto_mailer {

const std::string ADDRESSES_MAIL_TYPE = "addresses-shows-count";

class MessageInfo {
public:
    virtual void json(json::ObjectBuilder builder) const = 0;
    virtual ~MessageInfo() {}
};

class AddressesMessageInfo : public MessageInfo {
public:
    AddressesMessageInfo(const NYT::TNode& row);

    void json(json::ObjectBuilder builder) const override;

    uint64_t puid() const { return puid_; }
    uint64_t showsCount() const { return showsCount_; }

protected:
    // For tests
    AddressesMessageInfo(uint64_t puid, uint64_t showsCount)
    : puid_(puid)
    , showsCount_(showsCount)
    { }

private:
    uint64_t puid_;
    uint64_t showsCount_;
};

}  // namespace maps::wiki::auto_mailer
