#pragma once

#include "filtration.h"

namespace maps::wiki::tasks::involvement {

class NewOnfootFeedbackCounter : public ICounter
{
public:
    NewOnfootFeedbackCounter(
        pqxx::transaction_base& coreTxn,
        pqxx::transaction_base& mrcReadTxn,
        std::optional<chrono::TimePoint> start,
        std::optional<chrono::TimePoint> finish,
        int64_t previousValue)
        : coreTxn_(coreTxn)
        , mrcReadTxn_(mrcReadTxn)
        , start_(std::move(start))
        , finish_(std::move(finish))
        , previousValue_(previousValue)
    { }

    int64_t count(
        const geolib3::MultiPolygon2& polygons) override;

private:
    pqxx::transaction_base& coreTxn_;
    pqxx::transaction_base& mrcReadTxn_;
    std::optional<chrono::TimePoint> start_;
    std::optional<chrono::TimePoint> finish_;
    int64_t previousValue_ = 0;
};

} // namespace maps::wiki::tasks::involvement
