#pragma once

#include "filtration.h"

namespace maps::wiki::tasks::involvement {

class NewObjectsWithFtTypeCounter : public ICommitsCounter
{
public:
    NewObjectsWithFtTypeCounter(
        std::vector<revision::DBID> commitIds,
        pqxx::transaction_base& coreTxn,
        std::string objectCategory,
        std::set<std::string> ftTypes);

private:
    int64_t countImpl(
        const geolib3::MultiPolygon2& polygons) override;

    pqxx::transaction_base& coreTxn_;
    const std::string objectCategory_;
    const std::set<std::string> ftTypes_;
};
} // namespace maps::wiki::tasks::involvement
