#pragma once

#include "grouped_notifications.h"
#include "grouper.h"
#include "notification_config.h"

#include <maps/wikimap/mapspro/libs/bell_client/include/client.h>

#include <yandex/maps/wiki/social/sent_notification_gateway.h>

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <maps/libs/json/include/value.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <cstdint>

namespace maps::wiki::notifications_dispatcher {

class BellSender {
public:
    BellSender(
        pgpool3::Pool& socialPool,
        const common::ExtendedXmlDoc& cfg,
        std::vector<int64_t> whitelist
    )
        : socialPool_(socialPool)
        , bellClient_(makeBellConfig(cfg))
        , whitelist_(std::move(whitelist))
    { }

    void sendPendingGroupedNotifications(
        Grouper& grouper,
        const BellNotificationConfig& notificationConfig
    );

private:
    static bell_client::Configuration makeBellConfig(
        const common::ExtendedXmlDoc& cfg
    );

    void sendGroupedNotification(
        GroupedNotificationGateway& gng,
        social::SentNotificationGateway& sentNotificationGateway,
        const BellNotificationConfig& notificationConfig,
        GroupedNotification& notification
    );

    pgpool3::Pool& socialPool_;
    bell_client::Client bellClient_;
    std::vector<int64_t> whitelist_;
};

}  // namespace maps::wiki::notifications_dispatcher