#pragma once

#include <maps/libs/sql_chemistry/include/gateway.h>
#include <maps/libs/json/include/value.h>

#include <yandex/maps/wiki/social/common.h>

#include <string>

namespace maps::wiki::notifications_dispatcher {

using Uid = social::TUid;

struct GroupedNotification {
    GroupedNotification() = default;

    GroupedNotification(
        Uid uid,
        std::string type,
        std::string groupKey,
        bool pending,
        maps::json::Value parameters
    )
        : uid(uid)
        , type(std::move(type))
        , groupKey(std::move(groupKey))
        , pending(pending)
        , parameters(std::move(parameters))
    { }

    Uid uid;
    std::string type;
    std::string groupKey;
    bool pending;
    maps::json::Value parameters{json::repr::ObjectRepr{}};

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.uid, t.type, t.groupKey, t.pending, t.parameters);
    }
};

namespace table {

using namespace sql_chemistry;

struct GroupedNotifications : Table<GroupedNotification> {
    static constexpr std::string_view name_{"social.grouped_notifications"sv};

    static constexpr Int64PrimaryKey uid{"uid"sv, name_};
    static constexpr StringPrimaryKey type{"type"sv, name_};
    static constexpr StringPrimaryKey groupKey{"group_key"sv, name_};
    static constexpr BooleanColumn pending{"pending"sv, name_};
    static constexpr JsonColumn parameters{"parameters"sv, name_};

    static constexpr auto columns_() {
        return std::tie(uid, type, groupKey, pending, parameters);
    }
};

}

using GroupedNotificationGateway = sql_chemistry::Gateway<table::GroupedNotifications>;

}  // namespace maps::wiki::notifications_dispatcher
