#include "grouper.h"

namespace maps::wiki::notifications_dispatcher {

void Grouper::processGroupedNotificationsBatch(
    pqxx::transaction_base& txnSocial,
    NotificationDataBatch& notificationDataBatch,
    const GroupInfo& groupInfo
) {
    GroupedNotificationGateway gng{txnSocial};
    auto groupedNotifications = getGroupedNotifications(
        gng, notificationDataBatch.users(), groupInfo);
    notificationDataBatch.merge(groupedNotifications);
    gng.upsert(notificationDataBatch.groupedNotifications(groupInfo));
}

std::vector<GroupedNotification>
Grouper::getPendingNotifications(
    pqxx::transaction_base& txnSocial,
    const std::string& notificationType,
    const std::vector<int64_t>& users
) {
    GroupedNotificationGateway gng{txnSocial};

    // Loading regardless of group_key
    auto clause = table::GroupedNotifications::type == notificationType &&
        table::GroupedNotifications::pending == true;

    if (users.size()) {
        return gng.load(clause && table::GroupedNotifications::uid.in(users));
    } else {
        return gng.load(clause);
    }
}

std::vector<GroupedNotification> Grouper::getGroupedNotifications(
    GroupedNotificationGateway& gng,
    const std::vector<int64_t>& users,
    const GroupInfo& groupInfo
) {
    return gng.load(
        table::GroupedNotifications::uid.in(users) &&
        table::GroupedNotifications::groupKey == groupInfo.groupKey &&
        table::GroupedNotifications::type == groupInfo.notificationType);
}

}  // maps::wiki::notifications_dispatcher