#pragma once

#include "grouped_notifications.h"
#include "notification_data_batch.h"

#include <contrib/libs/libpqxx/include/pqxx/transaction_base>

#include <string>
#include <vector>
#include <cstdint>

namespace maps::wiki::notifications_dispatcher {

struct GroupInfo {
    std::string groupKey;
    std::string notificationType;
};

class Grouper {
public:
    void processGroupedNotificationsBatch(
        pqxx::transaction_base& txnSocial,
        NotificationDataBatch& notificationDataBatch,
        const GroupInfo& groupInfo
    );

    std::vector<GroupedNotification> getPendingNotifications(
        pqxx::transaction_base& txnSocial,
        const std::string& notificationType,
        const std::vector<int64_t>& users
    );

private:
    std::vector<GroupedNotification> getGroupedNotifications(
        GroupedNotificationGateway& gng,
        const std::vector<int64_t>& users,
        const GroupInfo& groupInfo
    );
};

}  // namespace maps::wiki::notifications_dispatcher