#pragma once

#include "grouped_notifications.h"

#include <yandex/maps/wiki/social/sent_notification_gateway.h>

#include <maps/wikimap/mapspro/libs/bell_client/include/client.h>

namespace maps::wiki::notifications_dispatcher {

class NotificationConfig {
public:
    virtual social::SentNotification makeSentNotificationEntry(
        const GroupedNotification& notification,
        const std::string& channelPushId
    ) const = 0;

    virtual std::string grouperNotificationType() const = 0;
};

class BellNotificationConfig : public NotificationConfig {
public:
    virtual bell_client::PushInfo makeBellPushInfo(
        const GroupedNotification& notification
    ) const = 0;
};

}  // namespace maps::wiki::notifications_dispatcher