#pragma once

#include "notification_data_batch.h"

#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/social/profile_gateway.h>

#include <pqxx/transaction_base>

namespace maps::wiki::notifications_dispatcher {

class PublishedCommitsData : public NotificationDataBatch {
public:
    PublishedCommitsData() = default;
    explicit PublishedCommitsData(
        social::IProfileGateway& profileGateway,
        const std::list<revision::Commit>& commits
    );

    void merge(const std::vector<GroupedNotification>& groupedNotifications) override;

    std::vector<int64_t> users() const override;

    std::vector<GroupedNotification>
    groupedNotifications(const GroupInfo& groupInfo) const override;

    ~PublishedCommitsData() override = default;

private:
    std::unordered_map<Uid, size_t> usersCommitsCount_;
    std::unordered_map<Uid, std::string> usersLocales_;
};

}  // namespace maps::wiki::notifications_dispatcher