#include "published_commits_dispatcher.h"

#include "published_commits_source.h"

namespace maps::wiki::notifications_dispatcher {

namespace {

const std::string PUSH_INFO_ACTOR = "ya_map_editor";

}  // namespace

PublishedCommitsDispatcher::PublishedCommitsDispatcher(
    const common::ExtendedXmlDoc& cfg,
    pgpool3::Pool& corePool,
    pgpool3::Pool& socialPool,
    std::vector<int64_t> whitelist
)
    : corePool_(corePool)
    , socialPool_(socialPool)
    , notificationConfig_(
        cfg,
        bell_client::NotificationType::NmapsEditsRelease,
        PUSH_INFO_ACTOR,
        social::NotificationChannel::Bell,
        social::NotificationType::YourEditsArePublished)
    , bellSender_(socialPool, cfg, whitelist)
{ }

void PublishedCommitsDispatcher::updateNotificationData() {
    GroupInfo groupInfo{
        chrono::formatIsoDate(chrono::TimePoint::clock::now()),
        notificationConfig_.grouperNotificationType()
    };

    PublishedCommitsSource publishedCommitsSource{corePool_, socialPool_};
    publishedCommitsSource.groupBatches(grouper_, groupInfo);
}

void PublishedCommitsDispatcher::sendNotifications() {
    bellSender_.sendPendingGroupedNotifications(grouper_, notificationConfig_);
}

}  // namespace maps::wiki::notifications_dispatcher