#pragma once

#include "bell_sender.h"
#include "grouper.h"
#include "published_commits_notification_config.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <cstdint>

namespace maps::wiki::notifications_dispatcher {

class PublishedCommitsDispatcher {
public:
    PublishedCommitsDispatcher(
        const common::ExtendedXmlDoc& cfg,
        pgpool3::Pool& corePool,
        pgpool3::Pool& socialPool,
        std::vector<int64_t> whitelist
    );

    void updateNotificationData();

    void sendNotifications();

private:
    pgpool3::Pool& corePool_;
    pgpool3::Pool& socialPool_;

    PublishedCommitsNotificationConfig notificationConfig_;

    Grouper grouper_;
    BellSender bellSender_;
};

}  // namespace maps::wiki::notifications_dispatcher