#pragma once

#include "notification_config.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <maps/libs/locale/include/locale.h>

#include <map>

namespace maps::wiki::notifications_dispatcher {

class PublishedCommitsNotificationConfig : public BellNotificationConfig {
public:
    PublishedCommitsNotificationConfig(
        const common::ExtendedXmlDoc& cfg,
        bell_client::NotificationType bellNotificationType,
        std::string bellActor,
        social::NotificationChannel sentNotificationChannel,
        social::NotificationType sentNotificationType
    );

    bell_client::PushInfo makeBellPushInfo(const GroupedNotification& notification) const override;

    social::SentNotification makeSentNotificationEntry(
        const GroupedNotification& notification,
        const std::string& channelNotificationId
    ) const override;

    std::string grouperNotificationType() const override;

private:
    json::Value makeBellMeta(const GroupedNotification& notification) const;
    std::string nmapsUrl(const GroupedNotification& notification) const;

    bell_client::NotificationType bellNotificationType_;
    std::string bellActor_;

    social::NotificationChannel sentNotificationChannel_;
    social::NotificationType sentNotificationType_;

    std::map<locale::Locale, std::string> localizedNmapsUrl_;
};

}  // namespace maps::wiki::notifications_dispatcher