#pragma once

#include "notification_data_source.h"
#include "published_commits_data.h"

#include <yandex/maps/wiki/social/published_commits.h>

#include <yandex/maps/wiki/common/batch.h>

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::wiki::notifications_dispatcher {

class PublishedCommitsSource : public NotificationDataSource {
public:
    PublishedCommitsSource(
        pgpool3::Pool& corePool,
        pgpool3::Pool& socialPool
    );

    void groupBatches(Grouper& grouper, const GroupInfo& groupInfo) override;

private:
    PublishedCommitsData gatherUsersCommits(
        pqxx::transaction_base& txnSocial,
        const social::TIds& commitIds
    ) const;

    pgpool3::Pool& corePool_;
    pgpool3::Pool& socialPool_;

    social::TIds commitIds_;
};

}  // namespace maps::wiki::notifications_dispatcher
