#include "utils.h"

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/moderation.h>
#include <yandex/maps/wiki/common/moderation.h>

#include <string>

namespace maps::wiki::rating {

namespace {

std::unordered_set<acl::UID> fetchInactiveUids(pqxx::transaction_base& txn)
{
    acl::ACLGateway aclGateway(txn);
    std::unordered_set<acl::UID> uids;

    auto deletedUsers =
        aclGateway.users(0, 0, 0, acl::User::Status::Deleted, 0, 0);
    for (const auto& deleted : deletedUsers.value()) {
        uids.insert(deleted.uid());
    }

    auto bannedUsers =
        aclGateway.users(0, 0, 0, acl::User::Status::Banned, 0, 0);
    for (const auto& banned : bannedUsers.value()) {
        uids.insert(banned.uid());
    }

    return uids;
}

void
fectchUidsByRole(
    const acl::Role& role,
    acl::ACLGateway& aclGw,
    std::unordered_set<acl::UID>& uids)
{
    auto users = aclGw.users(
        0, role.id(), 0, std::nullopt, 0, 0);
    for (const auto& user : users.value()) {
        uids.insert(user.uid());
    }
}

void
fectchUidsByRole(
    const std::string& roleName,
    pqxx::transaction_base& txn,
    std::unordered_set<acl::UID>& uids)
{
    acl::ACLGateway aclGateway(txn);
    const auto role =
        aclGateway.role(roleName);
    fectchUidsByRole(role, aclGateway, uids);
}

void
fectchUidsByRolePrefix(
    const std::string& roleNamePrefix,
    pqxx::transaction_base& txn,
    std::unordered_set<acl::UID>& uids)
{
    acl::ACLGateway aclGateway(txn);
    const auto fetchedUids = acl_utils::uidsByModerationStatus(aclGateway, roleNamePrefix);
    uids.insert(fetchedUids.begin(), fetchedUids.end());
}


std::unordered_set<acl::UID> fetchYandexUids(pqxx::transaction_base& txn)
{
    std::unordered_set<acl::UID> uids;
    fectchUidsByRole(common::MODERATION_STATUS_ROBOT, txn, uids);
    fectchUidsByRolePrefix(common::MODERATION_STATUS_CARTOGRAPHER, txn, uids);
    fectchUidsByRolePrefix(common::MODERATION_STATUS_YANDEX_MODERATOR, txn, uids);
    return uids;
}

std::unordered_set<acl::UID> fetchOutsourcerUids(pqxx::transaction_base& txn)
{
    std::unordered_set<acl::UID> uids;
    fectchUidsByRole(common::OUTSOURCE_ROLE, txn, uids);
    return uids;
}

} // namespace

std::unordered_set<acl::UID> fetchSkipUids(pgpool3::Pool& corePool)
{
    auto txn = corePool.masterReadOnlyTransaction();
    auto skipUids = fetchInactiveUids(*txn);
    auto yandexUids = fetchYandexUids(*txn);
    auto outsourcerUids = fetchOutsourcerUids(*txn);
    skipUids.insert(std::begin(yandexUids), std::end(yandexUids));
    skipUids.insert(std::begin(outsourcerUids), std::end(outsourcerUids));
    return skipUids;
}

} // namespace maps::wiki::rating
