#include <maps/wikimap/mapspro/services/tasks_social/src/stats_updater/lib/badges.h>

#include <maps/libs/common/include/exception.h>

#include <algorithm>
#include <map>

namespace maps::wiki::stats_updater {

std::vector<EditsCountBadge>
computeNewEditsCountBadge(UserId userId, size_t oldTotalEdits, size_t newTotalEdits)
{
    ASSERT(oldTotalEdits <= newTotalEdits);

    const std::map<size_t, size_t> LEVEL_THRESHOLDS = {
        { 5,       1  },
        { 10,      2  },
        { 50,      3  },
        { 100,     4  },
        { 500,     5  },
        { 1000,    6  },
        { 5000,    7  },
        { 10000,   8  },
        { 50000,   9  },
        { 100000,  10 },
        { 500000,  11 },
        { 1000000, 12 },
        { 1500000, 13 },
        { 2000000, 14 },
        { 2500000, 15 },
        { 3000000, 16 },
        { 3500000, 17 },
        { 4000000, 18 },
        { 4500000, 19 },
        { 5000000, 20 },
    };

    auto oldNextLevel = LEVEL_THRESHOLDS.upper_bound(oldTotalEdits);
    auto newNextLevel = LEVEL_THRESHOLDS.upper_bound(newTotalEdits);

    std::vector<EditsCountBadge> badges;
    std::transform(
        oldNextLevel, newNextLevel,
        std::back_inserter(badges),
        [&](const auto& level){
            return EditsCountBadge{userId, level.first, level.second};
        }
    );

    return badges;
}

} // namespace maps::wiki::stats_updater
