#pragma once

#include <maps/wikimap/mapspro/services/tasks_social/src/stats_updater/lib/common.h>
#include <maps/wikimap/mapspro/services/tasks_social/src/stats_updater/lib/badges.h>

#include <yandex/maps/wiki/configs/editor/category_groups.h>
#include <yandex/maps/wiki/revision/commit.h>

#include <pqxx/pqxx>
#include <optional>
#include <vector>

namespace maps::wiki::stats_updater {

/*
 * Refresh user commits statistics and award users with badges (achievements).
 * Usage of this class is valid only if exclusive write access to
 * table 'social.stats' is guaranteed.
 *
 */
class CommitsProcessor
{
public:
    CommitsProcessor(
        pqxx::transaction_base& socialTxn,
        const configs::editor::CategoryGroups& categoryGroups);

    void processCommits(const std::list<revision::Commit>& commits);

    const std::vector<EditsCountBadge>& getEditsBadges() const;

private:
    struct UpdateUserTotalEdits
    {
        size_t newTotalEdits{};
        size_t oldTotalEdits{};
        bool statExists{};
    };

    UpdateUserTotalEdits updateTotalEditsInStat(
        UserId user, size_t editsCountDelta);

    void createNewStat(
        UserId user, size_t editsCountDelta, chrono::TimePoint firstCommitAt);

    UpdateUserTotalEdits updateTotalEditsInStatV2(
        UserId user, size_t editsCountDelta, chrono::TimePoint firstCommitAt);

    void saveBadgeToSocial(const EditsCountBadge& badge);

private:
    pqxx::transaction_base& socialTxn_;
    const configs::editor::CategoryGroups& categoryGroups_;
    std::vector<EditsCountBadge> editsBadges_;
};

} // namespace maps::wiki::stats_updater
