#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>

#include <yandex/maps/wiki/configs/editor/category_groups.h>

#include <aws/sqs/SQSClient.h>

namespace maps::wiki::stats_updater {

class StatsUpdater
{
public:
    StatsUpdater(
        pgpool3::Pool& corePool,
        pgpool3::Pool& socialPool,
        const configs::editor::CategoryGroups& categoryGroups,
        const sqs::Configuration& sqsConfig,
        const Aws::SQS::SQSClient& sqsClient);

    void doWork() const;

private:
    pgpool3::Pool& corePool_;
    pgpool3::Pool& socialPool_;

    const configs::editor::CategoryGroups& categoryGroups_;
    const sqs::Configuration& sqsConfig_;
    const Aws::SQS::SQSClient& sqsClient_;
};

} // namespace maps::wiki::stats_updater
