#include <maps/wikimap/mapspro/services/tasks_social/src/stats_updater/lib/badges.h>
#include <library/cpp/testing/unittest/registar.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::stats_updater::tests {

namespace {

const UserId USER_ID = 100;

}

Y_UNIT_TEST_SUITE(new_badges) {

Y_UNIT_TEST(new_edits_not_less_than_old_edits)
{
    UNIT_ASSERT_EXCEPTION(computeNewEditsCountBadge(USER_ID, 30, 29), LogicError);
}

Y_UNIT_TEST(no_badge)
{
    auto badges = computeNewEditsCountBadge(USER_ID, 3, 4);
    UNIT_ASSERT(badges.empty());
}

Y_UNIT_TEST(single_badge)
{
    auto badges = computeNewEditsCountBadge(USER_ID, 99, 101);

    UNIT_ASSERT_EQUAL(badges.size(), 1);
    const auto& badge = badges.front();

    UNIT_ASSERT_EQUAL(badge.user, USER_ID);
    UNIT_ASSERT_EQUAL(badge.editsCount, 100);
    UNIT_ASSERT_EQUAL(badge.level, 4);
}

Y_UNIT_TEST(single_badge_exact_reach)
{
    auto badges = computeNewEditsCountBadge(USER_ID, 99, 100);

    UNIT_ASSERT_EQUAL(badges.size(), 1);
    const auto& badge = badges.front();

    UNIT_ASSERT_EQUAL(badge.user, USER_ID);
    UNIT_ASSERT_EQUAL(badge.editsCount, 100);
    UNIT_ASSERT_EQUAL(badge.level, 4);
}

Y_UNIT_TEST(multiple_badges)
{
    auto badges = computeNewEditsCountBadge(USER_ID, 99, 501);

    UNIT_ASSERT_EQUAL(badges.size(), 2);
    const auto& badge1 = badges[0];
    const auto& badge2 = badges[1];

    UNIT_ASSERT_EQUAL(badge1.user, USER_ID);
    UNIT_ASSERT_EQUAL(badge1.editsCount, 100);
    UNIT_ASSERT_EQUAL(badge1.level, 4);

    UNIT_ASSERT_EQUAL(badge2.user, USER_ID);
    UNIT_ASSERT_EQUAL(badge2.editsCount, 500);
    UNIT_ASSERT_EQUAL(badge2.level, 5);
}

} // Y_UNIT_TEST_SUITE(new_badges)

} // namespace maps::wiki::stats_updater::tests
