#include "export_poi.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/tasks/export.h>
#include <maps/wikimap/mapspro/libs/rubrics/include/mapping_utils.h>
#include <library/cpp/resource/resource.h>

#include <filesystem>
#include <memory>

namespace fs = std::filesystem;

int main(int argc, char* argv[]) try {
    using namespace maps::wiki::poi;

    maps::cmdline::Parser parser;
    auto config
        = parser.string("config").help("path to worker configuration");
    auto ymapsdf = parser.string("ymapsdf")
                       .help("path to YMapsDF configuration")
                       .defaultValue(YMAPSDF_XML_DEFAULT_PATH);
    auto calculatedResult = parser.string("calculated-result")
                              .help("path to result gz file");
    auto accurateResult = parser.string("accurate-result")
                              .help("path to result gz file");
    auto entrancesResult = parser.string("entrances-result")
                              .help("path to result gz file");
    parser.parse(argc, argv);

    std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> configXmlPtr;
    if (config.defined()) {
        configXmlPtr = std::make_unique<maps::wiki::common::ExtendedXmlDoc>(config);
    }
    else {
        configXmlPtr = maps::wiki::common::loadDefaultConfig();
    }

    auto mapping = NResource::Find(maps::wiki::rubrics::RUBRICS_MAPPING_CONFIG_RESOURCE_ID);
    Config cfg{*configXmlPtr, mapping, ymapsdf};
    cfg.setYMapsDfConnStr(maps::wiki::tasks::detectNearestExportDatabase(*configXmlPtr));

    exportPoi(cfg, [&calculatedResult, &accurateResult, &entrancesResult](const Config& cfg) {
        fs::copy(cfg.resultFilePathCalculatedRubricId(),
                 static_cast<std::string>(calculatedResult));
        fs::copy(cfg.resultFilePathAccurateRubricId(),
                 static_cast<std::string>(accurateResult));
        fs::copy(cfg.resultFilePathEntrancesFeed(),
                 static_cast<std::string>(entrancesResult));
    });
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << "Export POI failed: " << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << "Export POI failed: " << e.what();
    return EXIT_FAILURE;
}
