#pragma once

#include "../common.h"
#include "../config.h"
#include "feed_component.h"

#include <yandex/maps/wiki/revision/commit.h>
#include <pqxx/pqxx>

using namespace maps::wiki::revision;

namespace maps::wiki::poi {

class ComponentFeedData
{
public:
    explicit ComponentFeedData(const pqxx::row& row);
    ComponentFeedData(DBID objectId, DBID recentCommitId);

    std::vector<FeedComponentBase*> components();
    std::vector<const FeedComponentBase*> components() const;

    DBID recentCommitId() const { return recentCommitId_; }
    DBID objectId() const { return objectId_; }
    std::string json() const;
    bool stored() const { return stored_; }
    void markToStoreWithCommit(DBID commitId);

    const NamesFeedComponent& names() const { return namesComponent_; }

    const LonLatFeedComponent& coords() const { return lonLatComponent_; }

private:
    bool stored_;
    DBID objectId_ = 0;
    DBID recentCommitId_ = 0;
    NamesFeedComponent namesComponent_;
    LonLatFeedComponent lonLatComponent_;
};

class ComponentFeedCache
{
public:
    explicit ComponentFeedCache(DBIDSet oids, const Config& cfg);
    ~ComponentFeedCache();
    const ComponentFeedData& get(DBID objectId, DBID recentCommitId);
    void saveModified();
    //voidaaa removeObjects(DBIDSet oids);//collect all ids present in cache before run and all asked / delete diff
    DBID resetCache(DBID objectId);

private:
    std::vector<const revision::Commit*> loadVisibleApprovedUserCommits(
        pqxx::transaction_base& coreTxn, const std::set<DBID>& ids);

    const Config& cfg_;
    std::map<DBID, revision::Commit> commitsCache_;
    std::map<DBID, ComponentFeedData> cache_;
    size_t cacheHits_;
    size_t cacheMiss_;
};

} // namespace maps::wiki::poi
