#pragma once

#include "../common.h"

#include <yandex/maps/wiki/revision/branch.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/common/string_utils.h>
#include <maps/libs/json/include/value.h>

using namespace maps::wiki::revision;

namespace maps::wiki::poi {

class FeedComponentBase
{
public:
    virtual ~FeedComponentBase() {}

    bool updateFromCommit(
        const Branch& branch,
        pqxx::transaction_base& coreTxn,
        const revision::Commit& commit,
        DBID objectId);

    virtual std::string name() const = 0;

    void readJson(const maps::json::Value&);
    void updateJson(maps::json::ObjectBuilder&) const;
    bool hasData() const { return commitId_ != 0; }

    const chrono::TimePoint& actualizationDate() const { return actualizationDate_; }

protected:
    virtual bool processCommit(
        const Branch& branch,
        pqxx::transaction_base& coreTxn,
        const revision::Commit& commit,
        DBID objectId) = 0;

    virtual void fromJson(const maps::json::Value&) = 0;
    virtual void toJson(maps::json::ObjectBuilder&) const = 0;

    DBID commitId_ = 0;
    chrono::TimePoint actualizationDate_;

};

class LonLatFeedComponent : public FeedComponentBase
{
public:
    bool processCommit(
        const Branch& branch,
        pqxx::transaction_base& coreTxn,
        const revision::Commit& commit,
        DBID objectId) override;
    std::string name() const override { return "lonlat"; }
    void fromJson(const maps::json::Value&) override;
    void toJson(maps::json::ObjectBuilder&) const override;

    double lon() const { return lon_; }
    double lat() const { return lat_; }

private:
    double lon_ = 0;
    double lat_ = 0;
};

using LocalizedStrings = std::set<common::LocalizedString>;

class NamesFeedComponent : public FeedComponentBase
{
public:
    bool processCommit(
        const Branch& branch,
        pqxx::transaction_base& coreTxn,
        const revision::Commit& commit,
        DBID objectId) override;
    std::string name() const override{ return "names"; }
    void fromJson(const maps::json::Value&) override;
    void toJson(maps::json::ObjectBuilder&) const override;

    const LocalizedStrings& names() const { return names_; }
    const LocalizedStrings& shortNames() const { return shortNames_; }
    const LocalizedStrings& synonymNames() const { return synonymNames_; }

private:
    LocalizedStrings names_;
    LocalizedStrings shortNames_;
    LocalizedStrings synonymNames_;
};

} // namespace maps::wiki::poi
