#pragma once

#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <yandex/maps/mds/mds.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/mds_dataset/types.h>
#include <yandex/maps/wiki/revision/branch.h>
#include <yandex/maps/wiki/revision/snapshot_id.h>

#include <memory>
#include <string>

namespace maps::wiki::poi {

class Config {
public:
    Config(const common::ExtendedXmlDoc& configXml,
           const std::string& mappingContent,
           const std::string& yMapsDfXmlPath = YMAPSDF_XML_DEFAULT_PATH);

    /// for unit-tests only
    Config(const common::ExtendedXmlDoc& configXml,
           const std::string& branchStr,
           chrono::TimePoint timePoint,
           const std::string& tempDirPath,
           const std::string& mappingContent,
           const std::string& yMapsDfXmlPath);

    const revision::Branch& branch() const { return branch_; }
    const common::ExtendedXmlDoc& configXml() const { return configXml_; }
    const std::string& jsonDirPath() const { return jsonDirPath_; }
    pgpool3::Pool& mainPool() const { return mainPool_.pool(); }
    pgpool3::Pool& socialPool() const { return socialPool_.pool(); }
    const FtTypeIdToRubricIdMultimap& mapping() const { return mapping_; }
    const FtTypeIdToRubricIdMultimap& parentMapping() const { return parentMapping_; }
    const mds::Configuration& mdsConfig() const { return mdsConfig_; }
    const std::string& printedConfig() const { return printedConfig_; }

    /**
     * @return string used as temporary directory name, temporary YMapsDF
     * schema name and mds_dataset ID
     */
    const std::string& resourceName() const { return resourceName_; }

    const std::string& resultFilePathCalculatedRubricId() const { return resultFilePathCalculatedRubricId_; }
    const std::string& md5FilePathCalculatedRubricId() const { return md5FilePathCalculatedRubricId_; }
    const std::string& resultFilePathAccurateRubricId() const { return resultFilePathAccurateRubricId_; }
    const std::string& md5FilePathAccurateRubricId() const { return md5FilePathAccurateRubricId_; }
    const std::string& resultFilePathVerifiedCoordsFeed() const { return resultFilePathVerifiedCoordsFeed_; }
    const std::string& md5FilePathVerifiedCoordsFeed() const { return md5FilePathVerifiedCoordsFeed_; }

    const std::string& resultFilePathNamesFeed() const { return resultFilePathNamesFeed_; }
    const std::string& md5FilePathNamesFeed() const { return md5FilePathNamesFeed_; }

    const std::string& resultFilePathCoordsFeed() const { return resultFilePathCoordsFeed_; }
    const std::string& md5FilePathCoordsFeed() const { return md5FilePathCoordsFeed_; }

    const std::string& resultFilePathIndoorFeed() const { return resultFilePathIndoorFeed_; }
    const std::string& md5FilePathIndoorFeed() const { return md5FilePathIndoorFeed_; }
    const std::string& resultFilePathIndoorNamesFeed() const { return resultFilePathIndoorNamesFeed_; }
    const std::string& md5FilePathIndoorNamesFeed() const { return md5FilePathIndoorNamesFeed_; }

    const std::string& resultFilePathEntrancesFeed() const { return resultFilePathEntrancesFeed_; }
    const std::string& md5FilePathEntrancesFeed() const { return md5FilePathEntrancesFeed_; }

    const revision::SnapshotId& snapshotId() const { return snapshotId_; }
    const std::string& taskDirPath() const { return taskDirPath_; }
    const std::string& tempDirPath() const { return tempDirPath_; };
    const std::string& yMapsDfXmlPath() const { return yMapsDfXmlPath_; }

    std::string yMapsDfConnStr() const;
    void setYMapsDfConnStr(std::string connStr) { connStr_ = std::move(connStr); }

    pgpool3::Pool& yMapsDfPool() const;

private:
    const common::ExtendedXmlDoc& configXml_;
    mutable common::PoolHolder mainPool_;
    mutable common::PoolHolder socialPool_;
    const revision::Branch branch_;
    const revision::SnapshotId snapshotId_;

    std::string connStr_;
    mutable std::unique_ptr<pgpool3::Pool> yMapsDfPool_;

    const std::string yMapsDfXmlPath_;
    const mds::Configuration mdsConfig_;

    const std::string resourceName_;
    const std::string tempDirPath_;
    const std::string taskDirPath_;

    const std::string jsonDirPath_;
    const std::string resultFilePathCalculatedRubricId_;
    const std::string resultFilePathAccurateRubricId_;
    const std::string md5FilePathCalculatedRubricId_;
    const std::string md5FilePathAccurateRubricId_;
    const std::string resultFilePathVerifiedCoordsFeed_;
    const std::string md5FilePathVerifiedCoordsFeed_;

    const std::string resultFilePathNamesFeed_;
    const std::string md5FilePathNamesFeed_;

    const std::string resultFilePathCoordsFeed_;
    const std::string md5FilePathCoordsFeed_;

    const std::string resultFilePathIndoorFeed_;
    const std::string md5FilePathIndoorFeed_;
    const std::string resultFilePathIndoorNamesFeed_;
    const std::string md5FilePathIndoorNamesFeed_;

    const std::string resultFilePathEntrancesFeed_;
    const std::string md5FilePathEntrancesFeed_;

    const std::string printedConfig_;

    FtTypeIdToRubricIdMultimap mapping_;
    FtTypeIdToRubricIdMultimap parentMapping_;

    revision::Branch loadBranch(const std::string& branchStr) const;
    revision::SnapshotId maxSnapshotId() const;
    mds::Configuration makeMdsConfig() const;
};

} // maps::wiki::poi
