#include "entrances_formatter.h"
#include "poi_def.h"

#include <maps/libs/json/include/builder.h>
#include <string>

using namespace std::string_literals;

namespace maps::wiki::poi {

namespace {

const auto STR_ORIGINAL_ID = "originalId"s;
const auto STR_PERMALINK = "permalink"s;
const auto STR_ENTRANCES = "entrances"s;
const auto STR_LON = "lon"s;
const auto STR_LAT = "lat"s;
const auto STR_TYPE = "type"s;
const auto STR_OTHER = "other"s;

} // namespace

EntrancesYsonFormatter::EntrancesYsonFormatter(
    std::ostream& out)
    : out_(out)
    , builder_(out_)
{
    out_ << "[";
}

EntrancesYsonFormatter::~EntrancesYsonFormatter()
{
    out_ << "]";
}

void EntrancesYsonFormatter::append(const PoiDef& data)
{
    REQUIRE(data.id, "unspecified POI_ID");
    if (!data.entrances) {
        return;
    }
    builder_ << [&](json::ObjectBuilder objectBuilder) {
        objectBuilder[STR_ORIGINAL_ID] = data.id.get();
        if (!data.permalink.empty()) {
            objectBuilder[STR_PERMALINK] = data.permalink;
        }
        objectBuilder[STR_ENTRANCES] = [&](json::ArrayBuilder arrayBuilder) {
            for (const auto& entrance : *data.entrances) {
                arrayBuilder << [&](json::ObjectBuilder entranceBuilder) {
                    entranceBuilder[STR_LON] = entrance.lon;
                    entranceBuilder[STR_LAT] = entrance.lat;
                    entranceBuilder[STR_TYPE] = STR_OTHER;
                };
            }
        };
    };
}

} // namespace maps::wiki::poi
