#include "export_poi.h"

#include "dump.h"
#include "json2ymapsdf.h"
#include "revision2json.h"
#include "utils.h"

#include <maps/libs/log8/include/log8.h>

#include <boost/scope_exit.hpp>

#include <filesystem>

namespace fs = std::filesystem;

namespace maps {
namespace wiki {
namespace poi {

void exportPoi(const Config& cfg, OnExportFinished onExportFinished, const std::string& json2ymapsdfPath)
{
    cleanupOldDirs(cfg.tempDirPath());
    cleanupOldSchemas(cfg.yMapsDfPool());

    fs::create_directory(cfg.taskDirPath());
    BOOST_SCOPE_EXIT((&cfg)) { fs::remove_all(cfg.taskDirPath()); }
    BOOST_SCOPE_EXIT_END
    fs::create_directory(cfg.jsonDirPath());
    INFO() << "Export JSON-files from TDS";
    revision2json(cfg, json2ymapsdfPath);

    dropSchema(cfg.yMapsDfPool(), cfg.resourceName());
    BOOST_SCOPE_EXIT((&cfg))
    {
        dropSchema(cfg.yMapsDfPool(), cfg.resourceName());
    }
    BOOST_SCOPE_EXIT_END

    json2ymapsdf(cfg, Json2YMapsDfMode::Upload, json2ymapsdfPath);
    dump(cfg);
    makeMd5(cfg.resultFilePathCalculatedRubricId(), cfg.md5FilePathCalculatedRubricId());
    makeMd5(cfg.resultFilePathAccurateRubricId(), cfg.md5FilePathAccurateRubricId());
    makeMd5(cfg.resultFilePathVerifiedCoordsFeed(), cfg.md5FilePathVerifiedCoordsFeed());
    makeMd5(cfg.resultFilePathNamesFeed(), cfg.md5FilePathNamesFeed());
    makeMd5(cfg.resultFilePathCoordsFeed(), cfg.md5FilePathCoordsFeed());
    makeMd5(cfg.resultFilePathIndoorFeed(), cfg.md5FilePathIndoorFeed());
    makeMd5(cfg.resultFilePathIndoorNamesFeed(), cfg.md5FilePathIndoorNamesFeed());
    makeMd5(cfg.resultFilePathEntrancesFeed(), cfg.md5FilePathEntrancesFeed());
    onExportFinished(cfg);
}

} // poi
} // wiki
} // maps
