#pragma once

#include "common.h"
#include <ctemplate/template.h>

#include <ostream>
#include <memory>

namespace ct = ctemplate;

namespace maps {
namespace wiki {
namespace poi {

struct PoiDef;

class OutputStreamEmitter : public ct::ExpandEmitter {
public:
    OutputStreamEmitter(std::ostream& out) : out_(out) {}

    void Emit(char c) override { out_.put(c); }
    void Emit(const std::string& s) override { out_ << s; }
    void Emit(const char* s) override { out_ << s; }
    void Emit(const char* s, size_t slen) override { out_.write(s, slen); }

private:
    std::ostream& out_;
};

/// @brief This class formats poi data into XML format according to
/// the Sprav provider scheme.
class XmlFormatter {
public:
    /// @brief Create a formatter writing to specified output stream
    /// @p out.
    ///
    /// @note the stream will contain the full XML document only after
    /// formatter destruction.
    XmlFormatter(std::ostream& out);

    ~XmlFormatter();

    void append(const PoiDef& data);

private:
    OutputStreamEmitter emitter_;
};

} // namespace poi
} // namespace wiki
} // namespace maps
