#include "formatter_helpers.h"

#include <string>

namespace maps::wiki::poi {

void
dumpRubrics(
    const PoiDef& poiDef,
    ct::TemplateDictionary& dict)
{
    if (poiDef.userDefinedRubricId) {
        auto* rubricIdTemplate =
            dict.AddSectionDictionary("POI_RUBRIC_ID_SECTION");
        rubricIdTemplate->SetValue(
            "POI_RUBRIC_ID",
            std::to_string(*poiDef.userDefinedRubricId));

        for (const auto& rubricId : poiDef.userDefinedSecondaryRubricIds) {
            auto* rubricIdTemplate =
                dict.AddSectionDictionary("POI_SECONDARY_RUBRIC_IDS_SECTION");
            rubricIdTemplate->SetValue(
                "POI_SECONDARY_RUBRIC_ID",
                std::to_string(rubricId));
        }
    } else {
        for (const auto& rubricId : poiDef.rubricIds) {
            auto* rubricIdTemplate =
                dict.AddSectionDictionary("POI_RUBRIC_ID_SECTION");
            rubricIdTemplate->SetValue(
                "POI_RUBRIC_ID",
                std::to_string(rubricId));
        }
    }
}

} // namespace maps::wiki::poi
