#include "json2ymapsdf.h"

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/shell_cmd.h>
#include <yandex/maps/shellcmd/logging_ostream.h>

#include <sstream>

namespace maps {
namespace wiki {
namespace poi {

void json2ymapsdf(const Config& cfg, Json2YMapsDfMode mode, const std::string& json2ymapsdfPath)
{
    INFO() << "load json from " << cfg.jsonDirPath();
    std::ostringstream cmdStr;

    cmdStr << (json2ymapsdfPath.empty() ? "json2ymapsdf" : json2ymapsdfPath)
           << " --conn=\"" << cfg.yMapsDfConnStr() << "\""
           << " --schema=" << cfg.resourceName()
           << " --transform-cfg=" << cfg.yMapsDfXmlPath()
           << " --json-dir=" << cfg.jsonDirPath() << " --print-progress"
           << (mode == Json2YMapsDfMode::PrintConfig
                   ? " --print-configuration=" + cfg.printedConfig()
                   : "");

    shell::stream::LoggingOutputStream loggedOut(
        [](const std::string& s) { INFO() << "json2ymapsdf.stdout: " << s; });
    shell::stream::LoggingOutputStream loggedErr(
        [](const std::string& s) { INFO() << "json2ymapsdf.stderr: " << s; });

    shell::ShellCmd cmd(cmdStr.str(), loggedOut, loggedErr);
    REQUIRE(cmd.run() == 0, "json2ymapsdf tool failed");
}

} // poi
} // wiki
} // maps
