#include "poi_def.h"

#include <maps/wikimap/mapspro/libs/poi_feed/include/helpers.h>
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_settings_config.h>

namespace maps::wiki::poi {

bool isFullMergeImplemented(const PoiDef& poiDef)
{
    static const auto ftTypeWithfeedSettings = poi_feed::FeedSettingsConfig().configuredFtTypes();
    return poiDef.ftTypeId &&
        ftTypeWithfeedSettings.count(*poiDef.ftTypeId) &&
        poi_feed::isFullMergeImplemented(*poiDef.ftTypeId);
}

} // namespace maps::wiki::poi
