#include "publish.h"

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/mds_dataset/dataset_gateway.h>
#include <yandex/maps/wiki/mds_dataset/export_metadata.h>

namespace maps {
namespace wiki {
namespace poi {

mds_dataset::FileLinks publish(const Config& cfg,
                               mds_dataset::DatasetStatus status,
                               const std::vector<std::string>& filePaths)
{
    namespace ds = mds_dataset;
    ds::ExportMetadata metadata(ds::BasicMetadata(cfg.resourceName(), status),
                                ds::Subset::Poi, mds_dataset::IsTested::Yes);
    mds::Mds mdsClient(cfg.mdsConfig());
    ds::DatasetWriter<ds::ExportMetadata> writer(mdsClient, cfg.mainPool());
    INFO() << "Creating dataset with id " << cfg.resourceName();
    auto dataset = writer.createDataset(metadata, filePaths);
    INFO() << "Successfully created dataset " << dataset;
    return dataset.fileLinks();
}

} // poi
} // wiki
} // maps
