#include "search_path_guard.h"

#include <maps/libs/log8/include/log8.h>

namespace maps {
namespace wiki {
namespace poi {
namespace {

const std::string SEARCH_PATH_VARIABLE = "search_path";

} // anonymous namespace

SearchPathGuard::SearchPathGuard(pqxx::transaction_base& txn,
                                 const std::string& schema)
    : txn_(txn), originalSearchPath_(txn_.get_variable(SEARCH_PATH_VARIABLE))
{
    txn_.set_variable(SEARCH_PATH_VARIABLE, schema + ", public");
}

SearchPathGuard::~SearchPathGuard()
{
    try {
        txn_.set_variable(SEARCH_PATH_VARIABLE, originalSearchPath_);
    }
    catch (const std::exception& e) {
        ERROR() << "SearchPathGuard: " << e.what();
    }
    catch (...) {
        ERROR() << "SearchPathGuard: unknown error";
    }
}

} // namespace poi
} // namespace wiki
} // namespace maps
