#pragma once
#include <maps/wikimap/mapspro/services/tasks_sprav/src/export_poi_worker/config.h>

#include <yandex/maps/wiki/unittest/localdb.h>
#include <yandex/maps/wiki/unittest/config.h>
#include <util/generic/string.h>

namespace maps {
namespace wiki {
namespace poi {
namespace tests {

const unsigned long USER_ID = maps::wiki::common::WIKIMAPS_SPRAV_UID;

class SetLogLevelFixture
{
public:
    SetLogLevelFixture();
};

class PoiFixture : public SetLogLevelFixture, public unittest::MapsproDbFixture {
public:
    PoiFixture();

    std::time_t startTime() const;

    const Config& config() const;

    void fillYMapsDF();

    bool doesSchemaExist(const std::string& schema);

    const std::string& json2ymapsdfPath() const;

private:
    std::time_t fillTds();
    unittest::ConfigFileHolder configFileHolder_;
    common::ExtendedXmlDoc configXml_;
    std::time_t startTime_;
    Config cfg_;
};


class BuildDirGuard
{
public:
    BuildDirGuard();
    ~BuildDirGuard();

private:
    TString originalDir_;
};

}//tests
}//poi
}//wiki
}//maps



