#include <maps/wikimap/mapspro/services/tasks_sprav/src/export_poi_worker/config.h>
#include "poi_fixture.h"
#include <maps/wikimap/mapspro/services/tasks_sprav/src/export_poi_worker/publish.h>

#include <library/cpp/testing/common/env.h>
#include <boost/test/unit_test.hpp>

#include <filesystem>

namespace fs = std::filesystem;
using namespace maps;
using namespace maps::wiki;
using namespace maps::wiki::poi;

namespace {
const std::string TEST_DATA_PATH = SRC_("tds.json");
} // anonymous namespace

BOOST_FIXTURE_TEST_SUITE(publish_test, tests::PoiFixture)

BOOST_AUTO_TEST_CASE(test_publish)
{
    fs::path file(TEST_DATA_PATH);
    auto links = publish(config(), mds_dataset::DatasetStatus::Available,
                         {file.string()});
    mds::Mds mdsClient(config().mdsConfig());
    for (const auto& link : links) {
        const auto& key = link.mdsKey();
        mdsClient.del({key.groupId, key.path});
    }
    BOOST_CHECK_EQUAL(links.size(), 1);
}
BOOST_AUTO_TEST_SUITE_END()
