#include <maps/wikimap/mapspro/services/tasks_sprav/src/export_poi_worker/utils.h>

#include <boost/test/unit_test.hpp>

#include <library/cpp/testing/common/env.h>

#include <filesystem>

namespace fs = std::filesystem;

namespace maps {
namespace wiki {
namespace poi {
namespace tests {

namespace {

const std::string TEST_DIR_PATH = (GetOutputPath() / "deleteme").c_str();
const std::string DATA_FILE_PATH = SRC_("tds.json");

class DirFixture {
public:
    DirFixture()
    {
        fs::remove_all(TEST_DIR_PATH);
        fs::create_directories(TEST_DIR_PATH);
    }
};

} // anonymous namespace

BOOST_FIXTURE_TEST_SUITE(utils_tests, DirFixture)

BOOST_AUTO_TEST_CASE(permalink_cleanup_test)
{
    for (const auto& permalink : {"", "1", "1234", "1304047935"}) {
        BOOST_CHECK_MESSAGE(isValidPermalink(permalink),
                            "Permalink " << permalink
                                         << " must be classified as valid");
    }
    for (const auto& permalink : {"1304047935)", "abcde", "x123abc456z7"}) {
        BOOST_CHECK_MESSAGE(!isValidPermalink(permalink),
                            "Permalink " << permalink
                                         << " must be classified as invalid");
    }
}

BOOST_AUTO_TEST_CASE(cleanup_old_dirs_test)
{
    auto oldDirName = makeResourceName(
        0, chrono::parseIsoDateTime("2015-06-16T15:25:21"));
    auto oldDirPath = TEST_DIR_PATH + "/" + oldDirName;
    fs::create_directory(oldDirPath);
    auto newDirName = makeResourceName(1, chrono::TimePoint::clock::now());
    auto newDirPath = TEST_DIR_PATH + "/" + newDirName;
    fs::create_directory(newDirPath);
    cleanupOldDirs(TEST_DIR_PATH);
    BOOST_CHECK(!fs::exists(oldDirPath));
    BOOST_CHECK(fs::exists(newDirPath));
}

BOOST_AUTO_TEST_CASE(md5_test)
{
    auto md5FilePath = TEST_DIR_PATH + "/tds.json.md5";
    makeMd5(DATA_FILE_PATH, md5FilePath);
    BOOST_CHECK_GT(fileSize(md5FilePath), 0);
}

BOOST_AUTO_TEST_SUITE_END()

} //namespace tests
} //namespace poi
} //namespace wiki
} //namespace maps
