#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <yandex/maps/wiki/revision/common.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <cstdint>
#include <string>

namespace maps {
namespace wiki {
namespace poi {

bool isValidPermalink(const std::string& permalink);

/**
 * @return string used as temporary directory name, temporary YMapsDF schema
 * name and mds_dataset ID
 */
std::string makeResourceName(revision::DBID approveOrder,
                             chrono::TimePoint timePoint);

void cleanupOldDirs(const std::string tempDirPath);

void dropSchema(pgpool3::Pool& pool, const std::string& schema);

void cleanupOldSchemas(pgpool3::Pool& pool);

void makeMd5(const std::string& sourceFile, const std::string& outputFile);

size_t fileSize(const std::string& filePath);

} // namespace poi
} // namespace wiki
} // namespace maps
