#pragma once

#include "config.h"

#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/libs/chrono/include/time_point.h>

namespace maps::wiki::merge_poi {

chrono::TimePoint altayDataDateISO(
    const std::string& nyakMappingYTURL);

poi_feed::FeedObjectDataVector readAltayCompanies(
    const std::string& nyakMappingYTURL,
    const std::unordered_set<std::string>& supportedNmapsLangs,
    size_t limit = 0);

struct IndoorCandidatesData
{
    IndoorCandidatesData(
        const std::string& nyakIndoorCandidatesYTURL,
        const EditorCfg& editorCfg,
        const std::unordered_set<std::string>& supportedNmapsLangs,
        size_t limit = 0);

    std::map<poi_feed::PermalinkId, poi_feed::PermalinkId> candidatePermalinkToLocatedAt;
    poi_feed::FeedObjectDataVector candidates;
};

std::vector<poi_feed::UnknownMappingData> readNyakMappingUnknown(
    const std::string& nyakMappingUnknownYTURL);

struct NyakMappingLocations
{
    std::string mainUrl;
    std::string unknownUrl;
    std::string nyakIndoorCandidatesYTURL;
};

NyakMappingLocations getNyakExportLocation();

std::set<poi_feed::PermalinkId> readGeoproductPermalinks();

} // namespace maps::wiki::merge_poi
