#pragma once

#include <yandex/maps/wiki/configs/editor/config_holder.h>
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>

#include <cstdint>

using namespace std::string_literals;
namespace maps::wiki::merge_poi {

using MergeTaskId = std::uint64_t;
using DispClass = std::uint16_t;
using FtTypeId = poi_feed::FtTypeId;
using ObjectId = poi_feed::ObjectId;
using CommitId = std::uint64_t;
const double DEFAULT_MIN_MOVE_METERS = 1.0;
const auto MAX_PROCESSING_TIME_HOURS = std::chrono::hours(6);
const size_t MAX_PROCESSING_PATCHES = 150000;
constexpr size_t QUERY_BATCH_SIZE = 100;
const auto STAT_TOKEN_ENV = "STAT_TOKEN"s;

const auto WORKING_SCHEMA = "sprav"s;
const auto EXPORT_POI_WORKER_FEED_DATA = WORKING_SCHEMA + ".export_poi_worker_feed_data"s;
const auto MERGE_POI_ALTAY_FEED_DATA = WORKING_SCHEMA + ".merge_poi_altay_feed_data"s;
const auto MERGE_POI_ALTAY_FEED_UNKNOWN = WORKING_SCHEMA + ".merge_poi_altay_feed_unknown"s;
const auto MERGE_POI_PATCH_QUEUE_ARCHIVE = WORKING_SCHEMA + ".merge_poi_patch_queue_archive"s;
const auto MERGE_POI_TASK = WORKING_SCHEMA + ".merge_poi_task"s;
const auto POI_CONFLICTS_DIFFALERT_MESSAGE = "poi-conflict"s;

const auto HTTP_OK = 200;

using IdsIndex = std::unordered_map<poi_feed::ObjectId, size_t>;
using PositionIndex = geolib3::StaticGeometrySearcher<
    poi_feed::FeedObjectData::Position, poi_feed::ObjectId>;

using EditorCfg = maps::wiki::configs::editor::ConfigHolder;
} // namespace maps::wiki::merge_poi
