#pragma once

#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_settings_config.h>
#include "common.h"
#include "feedback.h"

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <unordered_set>

namespace maps::wiki::merge_poi {

class Config {
public:
    explicit Config(const common::ExtendedXmlDoc& configXml);

    const common::ExtendedXmlDoc& configXml() const { return configXml_; }
    const EditorCfg& editorCfg() const { return editorCfg_; };
    pgpool3::Pool& corePool() const { return corePool_.pool(); }
    pgpool3::Pool& socialPool() const { return socialPool_.pool(); }
    const std::string& editorUrl() const { return editorUrl_; }
    const std::string& editorWriterUrl() const { return editorWriterUrl_; }
    const std::string& socialBackofficeUrl() const { return socialBackofficeUrl_; }
    const std::string& statUrl() const { return statUrl_; }
    const poi_feed::FeedSettingsConfig& feedSettingsConfig() const { return feedSettingsConfig_; }
    const std::unordered_set<std::string>& supportedNmapsLangs() const;

    TvmTicketProvider socialBackofficeTvmTicketProvider() const { return socialBackofficeTvmTicketProvider_; }
    void initTvm();

private:
    const common::ExtendedXmlDoc& configXml_;
    const EditorCfg editorCfg_;
    mutable common::PoolHolder corePool_;
    mutable common::PoolHolder socialPool_;
    const std::string editorUrl_;
    const std::string editorWriterUrl_;
    const std::string socialBackofficeUrl_;
    const std::string statUrl_;
    const poi_feed::FeedSettingsConfig feedSettingsConfig_;
    TvmTicketProvider socialBackofficeTvmTicketProvider_;
};

std::unordered_set<std::string> supportedNmapsLangs(const EditorCfg& editorCfg);

} // maps::wiki::merge_poi
