#include "db_helpers.h"

namespace maps::wiki::merge_poi {
namespace {
const auto FINAL_WAIT_FOR = "2 days"s;
}

std::unordered_set<poi_feed::ObjectId>
loadObjectIdsForActiveTasks(pqxx::transaction_base& socialTxn)
{
    const auto rows = socialTxn.exec(
        "SELECT object_id FROM sprav.tasks WHERE "
        " sprav_status NOT IN ('rejected', 'published') OR "
        " (now() - updated_at < interval '" + FINAL_WAIT_FOR + "')");
    std::unordered_set<poi_feed::ObjectId> objectIds;
    objectIds.reserve(rows.size());
    for (const auto& row: rows) {
        objectIds.insert(row[0].as<poi_feed::ObjectId>());
    }
    return objectIds;
}

} //namespace maps::wiki::merge_poi
