#pragma once

#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/libs/chrono/include/time_point.h>
#include <unordered_map>
#include <unordered_set>

namespace maps::wiki::merge_poi {
class Config;

class DeleteQueue {
public:
    explicit DeleteQueue(const Config& cfg);
    std::unordered_set<poi_feed::ObjectId> notYetToDelete(poi_feed::FeedObjectDataVector& patches);
    void load();
    void save() const;
private:
    std::optional<chrono::TimePoint::duration> age(poi_feed::ObjectId id) const;
    void enqueue(poi_feed::ObjectId id);
    void dequeue(poi_feed::ObjectId id);

    const Config& cfg_;
    const chrono::TimePoint now_;
    std::unordered_map<poi_feed::ObjectId, chrono::TimePoint> objectToDeleteSince_;
    std::unordered_set<poi_feed::ObjectId> newToDelete_;
    std::unordered_set<poi_feed::ObjectId> toRemoveFromQueue_;
};

} // namespace maps::wiki::merge_poi
