#include "diff_alert.h"
#include "config.h"
#include "message.h"

#include <yandex/maps/wiki/social/event_alert.h>
#include <yandex/maps/wiki/social/gateway.h>

using namespace maps::wiki::social;
using namespace std::string_literals;
namespace maps::wiki::merge_poi {

struct AlertData {
    uint32_t priority;
    std::string description;
};

const std::unordered_map<std::string, AlertData> MESSAGE_TO_ALERT_DATA
    {
        {message::DELETE_INDOOR, {2, "poi-indoor-delete"s}},
        {message::INDOOR_POI_SPRAV_TOO_FAR, {2, "indoor-poi-sprav-too-far"}},
        {message::MOVE_ADDR_COLLISION, {2, "poi-move-addr-collision"s}},
        {message::MOVE_BLD_CHANGE, {2, "poi-move-bld-change"s}},
        {message::MOVE_ENTRANCE_COLLISION, {3, "poi-move-entrance-collision"s}},
        {message::MOVE_POI_COLLISION, {2, "poi-move-poi-collision"s}},
        {message::RENAMED_LANG_LOST, {3, "poi-name-lang-lost"s}},
        {message::RENAMED_WITH_RUBRIC, {3, "poi-has-rubric-name"s}},
        {message::TOO_BIG_DISTANCE, {2, "poi-move-big-displacement"s}},
        {message::SEVERE_POI_CONFLICT, {0, POI_CONFLICTS_DIFFALERT_MESSAGE}},
        {message::POI_CONFLICT, {2, POI_CONFLICTS_DIFFALERT_MESSAGE}},
    };

void createDiffAlertMessages(
    ObjectId oid,
    CommitId commitId,
    const std::set<std::string>& messages,
    const Config& cfg)
{
    auto socialTxn = cfg.socialPool().masterWriteableTransaction();
    Gateway socialGW(*socialTxn);
    const auto tasks = socialGW.loadEditTasksByCommitIds({commitId});
    bool commit = false;
    for (const auto& task : tasks) {
        EventAlerts eventAlerts;
        const auto eventId = task.event().id();
        for (const auto& message : messages) {
            if (!MESSAGE_TO_ALERT_DATA.count(message)) {
                continue;
            }
            const auto& alertData = MESSAGE_TO_ALERT_DATA.at(message);
            eventAlerts.emplace_back(
                eventId,
                alertData.priority,
                alertData.description,
                oid);
        }
        if (eventAlerts.empty()) {
            continue;
        }
        socialGW.saveEventAlerts(eventAlerts);
        commit = true;
    }
    if (commit) {
        socialTxn->commit();
    }
}

} // namespace maps::wiki::merge_poi
