#pragma once

#include "common.h"
#include "queue.h"

#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/libs/http/include/http.h>
#include <functional>

namespace maps::wiki::merge_poi {

using TvmTicketProvider = std::function<std::string()>;

class FeedbackClient
{
public:
    explicit FeedbackClient(std::string feedbackApiUrl);
    PatchResult createMoveTask(
        const poi_feed::FeedObjectData&,
        const editor_client::BasicEditorObject&);
    PatchResult createDeleteTask(
        const poi_feed::FeedObjectData&,
        const editor_client::BasicEditorObject&);
    PatchResult createMissingIndoorPoiTask(const poi_feed::FeedObjectData&);
    PatchResult createVerifyPositionTask(const poi_feed::FeedObjectData&);

    void setTvmTicketProvider(TvmTicketProvider tvmTicketProvider)
    {
        tvmTicketProvider_ = tvmTicketProvider;
    }

private:
    PatchResult submitTask(std::string body);

    const std::string apiUrl_;
    TvmTicketProvider tvmTicketProvider_;
    http::Client httpClient_;
};

std::string
prepareMovePoiTaskJsonBody(
    const poi_feed::FeedObjectData& patchData,
    const editor_client::BasicEditorObject& editorData);

std::string
prepareDeletePoiTaskJsonBody(
    const poi_feed::FeedObjectData& patchData,
    const editor_client::BasicEditorObject& editorData);

std::string
prepareCreateIndoorPoiTaskJsonBody(
    const poi_feed::FeedObjectData& candidate);

std::string
prepareVerifyPositionTaskJsonBody(
    const poi_feed::FeedObjectData& candidate);
} //  maps::wiki::merge_poi
