#include "helpers.h"
#include <maps/wikimap/mapspro/libs/poi_feed/include/helpers.h>

namespace maps::wiki::merge_poi {

namespace {
const std::string LANDMARKS_RESOURCE_KEY = "LANDMARKS_RESOURCE";
}

IdsIndex createIndex(const poi_feed::FeedObjectDataVector& data)
{
    std::unordered_map<poi_feed::ObjectId, size_t> index;
    for (size_t i = 0; i < data.size(); ++i) {
        index.emplace(data[i].nmapsId(), i);
    }
    return index;
}

bool isFullMergeImplemented(const poi_feed::FeedObjectData& data)
{
    return data.ftTypeId() && poi_feed::isFullMergeImplemented(*data.ftTypeId());
}
} // namespace maps::wiki:merge_poi
